from gpio import gpio as g
import pigpio

import asyncio
from websockets.asyncio.client import connect

import socket
import os
import sys
import signal
import subprocess

PI_MODEL = subprocess.check_output(['cat', '/proc/device-tree/model'])
HOST_NAME = socket.gethostname()

DEVICE_NAME = f'{HOST_NAME}@{PI_MODEL}'

async def client():
    pi = pigpio.pi()
    uri = 'ws://'+os.environ.get('SERVER','localhost')+':5000'
    
    async with connect(uri) as websocket:
        await websocket.send(f"META Name:{DEVICE_NAME}")
        await websocket.send(f"META GPIO:{','.join([str(i) for i in range(2,28)])}")

        while True:
            cmd = await websocket.recv()
            cmd = cmd.upper().strip()
            # await websocket.send(f"received: {msg}")
            if cmd == "DISCONNECT":
                await websocket.send(f"bye, from {DEVICE_NAME}")
                break
            elif cmd.startswith("MODE"):
                pin = 0
                mode = ""
                try:
                    cmd, pin, mode = cmd.split(" ")
                    pin = int(pin)
                except:
                    await websocket.send("invalid command")
                    continue
                if mode == "OUT":
                    try:
                        g.set_mode_output(pi, pin)
                    except:
                        await websocket.send(f"error trying to put {pin} as OUT")
                        continue
                elif mode == "IN":
                    try:
                        g.set_mode_input(pi, pin, pigpio.PUD_DOWN) # todo: commands for different pull up down
                    except:
                        await websocket.send(f"error trying to put {pin} as IN")
                        continue       
            elif cmd.startswith("WRITE"):
                pin = 0
                value = ""
                try:
                    cmd, pin, value = cmd.split(" ")
                    pin = int(pin)
                except:
                    await websocket.send("invalid command")
                    continue
                if value == "HIGH":
                    try:
                        g.write_pin(pi, pin, g.HIGH)
                    except:
                        await websocket.send(f"error trying to write HIGH to {pin}")
                        continue
                elif value == "LOW":
                    try:
                        g.write_pin(pi, pin, g.LOW)
                    except:
                        await websocket.send(f"error trying to write LOW to {pin}")
                        continue
                else:
                    await websocket.send("invalid command")
                    continue
            elif cmd.startswith("READ"):
                pin = 0
                value = 0
                try:
                    cmd, pin = cmd.split(" ")
                    pin = int(pin)
                except:
                    await websocket.send("invalid command")
                    continue
                try:
                    value = "LOW" if g.read_pin(pi, pin) == 0 else "HIGH"
                except Exception as e:
                    # print(e) # debug
                    await websocket.send(f"error trying to read pin {pin}")
                    continue
                await websocket.send(f"READING {pin}:{value}")
                continue
            else:
                await websocket.send("invalid command")
                continue


def signal_handler(sig, frame):
    print('Exiting! Requested by user.')
    sys.exit(0)


if __name__ == '__main__':
    signal.signal(signal.SIGINT, signal_handler)
    asyncio.run(client())