import pigpio

HIGH = 1
LOW = 0


def set_mode_output(gpio, pin, ctes=pigpio):
    gpio.set_mode(pin, ctes.OUTPUT)

def set_mode_input(gpio, pin, pullupdown=pigpio.PUD_OFF, ctes=pigpio):
    gpio.set_mode(pin, ctes.INPUT)
    gpio.set_pull_up_down(pin, pullupdown)

def write_pin(gpio, pin, level, ctes=pigpio):
    mode = gpio.get_mode(pin)
    if mode != ctes.OUTPUT: 
        raise PinIsNotOutputError
    else:
        gpio.write(pin, level)

def read_pin(gpio, pin, ctes=pigpio):
    mode = gpio.get_mode(pin)
    if mode != ctes.INPUT:
        raise PinIsNotInputError
    else:
        return gpio.read(pin)

class PinIsNotOutputError(Exception):
    pass

class PinIsNotInputError(Exception):
    pass